(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      7129,        244]*)
(*NotebookOutlinePosition[     10714,        341]*)
(*  CellTagsIndexPosition[     10418,        329]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Help...", "Command",
  CellTags->{"HelpDialog", "introHelpDialogID"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Help", "SR"],
  " opens the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " Help Browser."
}], "Usage",
  CellTags->{"HelpDialog", "introHelpDialogID"}],

Cell[TextData[{
  "\[FilledSmallSquare] The Help Browser lets you access a wide range of \
notebooks and other material to get help while you are using ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Notes",
  CellTags->{"HelpDialog", "introHelpDialogID"}],

Cell[TextData[{
  "\[FilledSmallSquare] See the ",
  StyleBox["Mathematica", "TI"],
  " book:  ",
  ButtonBox["Section 1.3.8",
    ButtonData:>{"1.3.8"},
    ButtonStyle->"MainBookLink"],
  ", and  ",
  ButtonBox["Section 1.3.9",
    ButtonData:>{"1.3.9"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"HelpDialog", "introHelpDialogID"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Registration...", "Command",
  CellTags->"Registration"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Registration", "SR"],
  " opens the online ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " registration form."
}], "Usage",
  CellTags->"Registration"],

Cell[TextData[{
  "\[FilledSmallSquare] If you are not the primary registration contact for \
this copy of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", you can still register and get our mailings by filling out the online  ",
  
  StyleBox[ButtonBox["Mathematica",
    ButtonData:>{
      ToFileName[
       {$TopDirectory, "Registration", "Notebook", 
        "MathematicaInformationForm.nb"}], None},
    ButtonStyle->"Hyperlink"],
    FontSlant->"Italic"],
  ButtonBox[" Information Form",
    ButtonData:>{
      ToFileName[
       {$TopDirectory, "Registration", "Notebook", 
        "MathematicaInformationForm.nb"}], None},
    ButtonStyle->"Hyperlink"],
  "."
}], "Notes",
  CellTags->"Registration"],

Cell[TextData[
"\[FilledSmallSquare] You can also register on the web: \
http://www.wolfram.com/register."], "Notes",
  CellTags->"Registration"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Find in Help...", "Command",
  CellTags->"SelectionHelpDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Find in Help", "SR"],
  " looks up the selected word in the Help Browser."
}], "Usage",
  CellTags->"SelectionHelpDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] Type a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " function name or topic in a notebook, select that word, and then choose",
  StyleBox[" Find in Help.", "SR"]
}], "Notes",
  CellTags->"SelectionHelpDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] Keyboard shortcuts:",
  StyleBox[" ", "C1"],
  StyleBox["F1", "C1MR"],
  StyleBox[" ", "C1"],
  StyleBox["(Windows)", "Notes"],
  "; ",
  StyleBox["\[ShiftKey]\[KeyBar]\[CommandKey]\[LeftModified]", "C1"],
  StyleBox["F", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Macintosh, NeXT); ", "Notes"],
  " ",
  StyleBox["\[ShiftKey]\[KeyBar]\[Mod1Key]\[LeftModified]", "C1"],
  StyleBox["F", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(X).", "Notes"]
}], "Notes",
  AspectRatioFixed->False,
  CellTags->"SelectionHelpDialog"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Why the Beep?...", "Command",
  CellTags->{"ExplainBeepDialog", "explainWhyTheBeepDialogID"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Why the Beep", "SR"],
  " brings up an explanation of why the front end produced a beep."
}], "Usage",
  CellTags->{"ExplainBeepDialog", "explainWhyTheBeepDialogID"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Mathematica",
    FontWeight->"ExtraLight",
    FontSlant->"Italic"],
  " beeps whenever you try to do something it can't do or doesn't understand. \
Choosing this command explains the problem. No matter how many actions you \
have performed since the beep, the message only concerns the last time ",
  StyleBox["Mathematica",
    FontWeight->"ExtraLight",
    FontSlant->"Italic"],
  " beeped, and it also tells you how long ago the beep occurred. "
}], "Notes",
  CellTags->{"ExplainBeepDialog", "explainWhyTheBeepDialogID"}],

Cell[TextData[{
  "\[FilledSmallSquare] Keyboard shortcuts: ",
  StyleBox["\[ShiftKey]\[KeyBar]\[CommandKey]\[LeftModified]", "C1"],
  StyleBox["H", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Windows)", "Notes"],
  "; ",
  StyleBox["\[ShiftKey]\[KeyBar]\[CommandKey]\[LeftModified]", "C1"],
  StyleBox["H", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Macintosh, NeXT); ", "Notes"],
  " ",
  StyleBox["\[ShiftKey]\[KeyBar]\[Mod1Key]\[LeftModified]", "C1"],
  StyleBox["H", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(X).", "Notes"]
}], "Notes",
  AspectRatioFixed->False,
  CellTags->"ExplainBeepDialog"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Rebuild Help Index...", "Command",
  CellTags->"RebuildHelpIndex"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Rebuild Help Index", "SR"],
  StyleBox[" rebuilds the categories and index for the Help Browser", "Text"],
  
  "."
}], "Usage",
  CellTags->"RebuildHelpIndex"],

Cell[TextData[
"\[FilledSmallSquare] Use this command when you have installed an add-on \
package or modified documentation files."], "Notes",
  CellTags->"RebuildHelpIndex"]
}, Open  ]]
},
FrontEndVersion->"NeXT 3.0 Beta 3",
ScreenRectangle->{{0, 1053}, {0, 832}},
WindowToolbars->{},
CellGrouping->Manual,
WindowSize->{520, 365},
WindowMargins->{{4, Automatic}, {Automatic, 1}},
PrintingCopies->1,
PrintingPageRange->{1, Automatic},
Magnification->1,
StyleDefinitions -> "HelpBrowser.nb"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "HelpDialog"->{
    Cell[1731, 51, 75, 1, 34, "Command",
      CellTags->{"HelpDialog", "introHelpDialogID"}],
    Cell[1809, 54, 218, 8, 29, "Usage",
      CellTags->{"HelpDialog", "introHelpDialogID"}],
    Cell[2030, 64, 274, 7, 36, "Notes",
      CellTags->{"HelpDialog", "introHelpDialogID"}],
    Cell[2307, 73, 358, 13, 22, "Notes",
      CellTags->{"HelpDialog", "introHelpDialogID"}]},
  "introHelpDialogID"->{
    Cell[1731, 51, 75, 1, 34, "Command",
      CellTags->{"HelpDialog", "introHelpDialogID"}],
    Cell[1809, 54, 218, 8, 29, "Usage",
      CellTags->{"HelpDialog", "introHelpDialogID"}],
    Cell[2030, 64, 274, 7, 36, "Notes",
      CellTags->{"HelpDialog", "introHelpDialogID"}],
    Cell[2307, 73, 358, 13, 22, "Notes",
      CellTags->{"HelpDialog", "introHelpDialogID"}]},
  "Registration"->{
    Cell[2702, 91, 62, 1, 34, "Command",
      CellTags->"Registration"],
    Cell[2767, 94, 217, 8, 29, "Usage",
      CellTags->"Registration"],
    Cell[2987, 104, 723, 22, 36, "Notes",
      CellTags->"Registration"],
    Cell[3713, 128, 145, 3, 22, "Notes",
      CellTags->"Registration"]},
  "SelectionHelpDialog"->{
    Cell[3895, 136, 69, 1, 34, "Command",
      CellTags->"SelectionHelpDialog"],
    Cell[3967, 139, 177, 5, 29, "Usage",
      CellTags->"SelectionHelpDialog"],
    Cell[4147, 146, 262, 7, 36, "Notes",
      CellTags->"SelectionHelpDialog"],
    Cell[4412, 155, 594, 18, 22, "Notes",
      CellTags->"SelectionHelpDialog"]},
  "ExplainBeepDialog"->{
    Cell[5043, 178, 99, 1, 70, "Command",
      CellTags->{"ExplainBeepDialog", "explainWhyTheBeepDialogID"}],
    Cell[5145, 181, 221, 5, 70, "Usage",
      CellTags->{"ExplainBeepDialog", "explainWhyTheBeepDialogID"}],
    Cell[5369, 188, 582, 13, 70, "Notes",
      CellTags->{"ExplainBeepDialog", "explainWhyTheBeepDialogID"}],
    Cell[5954, 203, 655, 18, 70, "Notes",
      CellTags->"ExplainBeepDialog"]},
  "explainWhyTheBeepDialogID"->{
    Cell[5043, 178, 99, 1, 70, "Command",
      CellTags->{"ExplainBeepDialog", "explainWhyTheBeepDialogID"}],
    Cell[5145, 181, 221, 5, 70, "Usage",
      CellTags->{"ExplainBeepDialog", "explainWhyTheBeepDialogID"}],
    Cell[5369, 188, 582, 13, 70, "Notes",
      CellTags->{"ExplainBeepDialog", "explainWhyTheBeepDialogID"}]},
  "RebuildHelpIndex"->{
    Cell[6646, 226, 72, 1, 70, "Command",
      CellTags->"RebuildHelpIndex"],
    Cell[6721, 229, 215, 7, 70, "Usage",
      CellTags->"RebuildHelpIndex"],
    Cell[6939, 238, 174, 3, 70, "Notes",
      CellTags->"RebuildHelpIndex"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"HelpDialog", 7875, 266},
  {"introHelpDialogID", 8279, 275},
  {"Registration", 8678, 284},
  {"SelectionHelpDialog", 9002, 293},
  {"ExplainBeepDialog", 9354, 302},
  {"explainWhyTheBeepDialogID", 9800, 311},
  {"RebuildHelpIndex", 10157, 318}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 75, 1, 34, "Command",
  CellTags->{"HelpDialog", "introHelpDialogID"}],
Cell[1809, 54, 218, 8, 29, "Usage",
  CellTags->{"HelpDialog", "introHelpDialogID"}],
Cell[2030, 64, 274, 7, 36, "Notes",
  CellTags->{"HelpDialog", "introHelpDialogID"}],
Cell[2307, 73, 358, 13, 22, "Notes",
  CellTags->{"HelpDialog", "introHelpDialogID"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[2702, 91, 62, 1, 34, "Command",
  CellTags->"Registration"],
Cell[2767, 94, 217, 8, 29, "Usage",
  CellTags->"Registration"],
Cell[2987, 104, 723, 22, 36, "Notes",
  CellTags->"Registration"],
Cell[3713, 128, 145, 3, 22, "Notes",
  CellTags->"Registration"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3895, 136, 69, 1, 34, "Command",
  CellTags->"SelectionHelpDialog"],
Cell[3967, 139, 177, 5, 29, "Usage",
  CellTags->"SelectionHelpDialog"],
Cell[4147, 146, 262, 7, 36, "Notes",
  CellTags->"SelectionHelpDialog"],
Cell[4412, 155, 594, 18, 22, "Notes",
  CellTags->"SelectionHelpDialog"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5043, 178, 99, 1, 70, "Command",
  CellTags->{"ExplainBeepDialog", "explainWhyTheBeepDialogID"}],
Cell[5145, 181, 221, 5, 70, "Usage",
  CellTags->{"ExplainBeepDialog", "explainWhyTheBeepDialogID"}],
Cell[5369, 188, 582, 13, 70, "Notes",
  CellTags->{"ExplainBeepDialog", "explainWhyTheBeepDialogID"}],
Cell[5954, 203, 655, 18, 70, "Notes",
  CellTags->"ExplainBeepDialog"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6646, 226, 72, 1, 70, "Command",
  CellTags->"RebuildHelpIndex"],
Cell[6721, 229, 215, 7, 70, "Usage",
  CellTags->"RebuildHelpIndex"],
Cell[6939, 238, 174, 3, 70, "Notes",
  CellTags->"RebuildHelpIndex"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

